/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.client.screen.button.ToggleTableRunningButton;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EliteAutoTableScreen
extends BaseContainerScreen<EliteAutoTableContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/elite_auto_table.png");
    private final RecipeSelectButton[] recipeSelectButtons = new RecipeSelectButton[3];
    private AutoTableTileEntity tile;

    public EliteAutoTableScreen(EliteAutoTableContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 220, 242);
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((EliteAutoTableContainer)this.m_6262_()).getPos();
        this.m_142416_((GuiEventListener)new ToggleTableRunningButton(x + 192, y + 96, pos, this::isRunning));
        this.recipeSelectButtons[0] = (RecipeSelectButton)this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 176, y + 7, pos, 0, this::isRecipeSelected));
        this.recipeSelectButtons[1] = (RecipeSelectButton)this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 189, y + 7, pos, 1, this::isRecipeSelected));
        this.recipeSelectButtons[2] = (RecipeSelectButton)this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 202, y + 7, pos, 2, this::isRecipeSelected));
        this.tile = this.getTileEntity();
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_7025_(stack, mouseX, mouseY);
        if (mouseX > x + 7 && mouseX < x + 20 && mouseY > y + 41 && mouseY < y + 118) {
            TextComponent text = new TextComponent(EliteAutoTableScreen.number((Object)this.getEnergyStored()) + " / " + EliteAutoTableScreen.number((Object)this.getMaxEnergyStored()) + " FE");
            this.m_96602_(stack, (Component)text, mouseX, mouseY);
        }
        if (mouseX > x + 192 && mouseX < x + 205 && mouseY > y + 95 && mouseY < y + 111) {
            this.m_96602_(stack, (Component)ModTooltips.TOGGLE_AUTO_CRAFTING.color(ChatFormatting.WHITE).build(), mouseX, mouseY);
        }
        for (RecipeSelectButton button : this.recipeSelectButtons) {
            ArrayList tooltip;
            boolean hasRecipe;
            BaseItemStackHandler recipe;
            if (!button.m_198029_() || (recipe = this.getRecipeInfo(button.getIndex())) == null) continue;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::m_41619_);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new Component[]{new TextComponent(output.m_41613_() + "x " + output.m_41786_().getString()), new TextComponent(""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(ChatFormatting.WHITE).build()});
            } else {
                tooltip = Lists.newArrayList((Object[])new Component[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(ChatFormatting.WHITE).build()});
            }
            this.m_96597_(stack, tooltip, mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        this.f_96547_.m_92883_(stack, title, 26.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 30.0f, (float)this.f_97727_ - 94.0f, 0x404040);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.renderDefaultBg(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        int i1 = this.getEnergyBarScaled();
        this.m_93228_(stack, x + 7, y + 119 - i1, 222, 78 - i1, 15, i1 + 1);
        if (this.isRunning()) {
            int i2 = this.getProgressBarScaled();
            this.m_93228_(stack, x + 191, y + 95, 238, 0, 13, i2);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 7; ++j) {
                    int index = i * 7 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 27 + j * 18), (int)(y + 18 + i * 18), (ItemRenderer)this.f_96542_);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 191), (int)(y + 71), (ItemRenderer)this.f_96542_);
        }
    }

    private boolean isRecipeSelected(int index) {
        return index == this.getSelected();
    }

    private AutoTableTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((EliteAutoTableContainer)this.m_6262_()).getPos())) instanceof AutoTableTileEntity) {
            AutoTableTileEntity table = (AutoTableTileEntity)tile;
            return table;
        }
        return null;
    }

    private boolean isRunning() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isRunning();
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getSelected() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getRecipeStorage().getSelected();
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getEnergyBarScaled() {
        int i = this.getEnergyStored();
        int j = this.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = this.getProgressRequired();
        return j != 0 && i != 0 ? i * 16 / j : 0;
    }
}

